if exist('REVS','var') && (REVS.verbose > 0)  disp(['Loading ' mfilename]); end

engine = class_REVS_engine;
engine.matrix_vintage = enum_matrix_vintage.past;
engine.name =  mfilename; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.displacement_L =     2.4000000; 
engine.inertia_kgm2 =    0.12000000; 
engine.cold_correction =    0.00000000; 
engine.fuel = class_REVS_fuel;
engine.fuel.id =  'RICARDO_GASOLINE'; 
engine.fuel.description =  'Estimated Ricardo Gasoline'; 
engine.fuel.density_kgpL_15C =    0.73971012; 
engine.fuel.energy_density_MJpkg =     44.000000; 
engine.fuel.carbon_weight_fraction =    0.88651246; 
engine.fuel.anti_knock_index = []; 
engine.fuel.research_octane_number = []; 
engine.fuel.motor_octane_number = []; 
engine.fuel.cetane_number = []; 
engine.fuel.alcohol_pct_vol =    0.00000000; 
engine.fuel.gCO2pgal =     9087.0000; 
engine.full_throttle_speed_radps = [    0.00000000,	   64.402649,	   98.750729,	   160.22123,	   195.61650,	   257.61060,	   418.77430,	   532.49995,	   659.31558,	   691.46454,	   711.98962,	 ]; 
engine.full_throttle_torque_Nm = [  2.2204460e-16,	   105.00000,	   169.00000,	   197.00000,	   202.00000,	   209.00000,	   218.00000,	   208.00000,	   179.00000,	   170.00000,	2.2204460e-16,	 ]; 
engine.naturally_aspirated_speed_radps = [    0.00000000,	   64.402649,	   98.750729,	   160.22123,	   195.61650,	   257.61060,	   418.77430,	   532.49995,	   659.31558,	   691.46454,	   711.98962,	 ]; 
engine.naturally_aspirated_torque_Nm = [  2.2204460e-16,	   105.00000,	   169.00000,	   197.00000,	   202.00000,	   209.00000,	   218.00000,	   208.00000,	   179.00000,	   170.00000,	2.2204460e-16,	 ]; 
engine.closed_throttle_speed_radps = [     103.88200,	   210.27727,	   312.79791,	   421.28757,	 ]; 
engine.closed_throttle_torque_Nm = [    -27.080000,	  -30.910000,	  -32.770000,	  -36.470000,	 ]; 
engine.throttle_duration_sec =    0.15000000; 
engine.boost_time_constant_sec =    0.15000000; 
engine.idle_speed_radps.axis_1.breakpoints = [    0.00000000,	   1.0000000,	 ]; 
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.table = [     71.200000,	   71.200000,	 ]; 
engine.idle_control_activation_speed_radps =     1.0000000; 
engine.idle_control_deactivation_speed_radps =    0.00000000; 
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;
engine.pedal_map_speed_radps = [    0.00000000,	   64.402649,	   98.750729,	   160.22123,	   195.61650,	   257.61060,	   418.77430,	   532.49995,	   659.31558,	   691.46454,	   711.98962,	 ]; 
engine.pedal_map_pedal_norm = [    0.00000000,	   1.0000000,	 ]; 
engine.pedal_map_Nm = [
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
   1873.3344,    1873.3344,    1350.6878,    832.48275,    681.85150,    517.76366,    318.50428,    250.48154,    202.30283,    192.89696,    187.33617, ]; 
engine.fuel_map_speed_radps = [     41.887900,	   62.831900,	   83.775800,	   104.72000,	   125.66400,	   146.60800,	   167.55200,	   188.49600,	   209.44000,	   230.38300,	   251.32700,	   272.27100,	   293.21500,	   314.15900,	   335.10300,	   356.04700,	   376.99100,	   397.93500,	   418.87900,	   439.82300,	   460.76700,	   481.71100,	   502.65500,	   523.59900,	   544.54300,	   565.48700,	   586.43100,	   607.37500,	   628.31900,	   649.26200,	   670.20600,	   691.15000,	   712.09400,	 ]; 
engine.fuel_map_torque_Nm = [    -60.000000,	  -50.000000,	  -40.000000,	  -30.000000,	  -20.000000,	  -10.000000,	  0.00000000,	   10.000000,	   20.000000,	   30.000000,	   40.000000,	   50.000000,	   60.000000,	   70.000000,	   80.000000,	   90.000000,	   100.00000,	   110.00000,	   120.00000,	   130.00000,	   140.00000,	   150.00000,	   160.00000,	   170.00000,	   180.00000,	   190.00000,	   200.00000,	   210.00000,	   220.00000,	   230.00000,	   240.00000,	   250.00000,	 ]; 
engine.fuel_map_gps = [
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, 0.0076911500,  0.044133958,  0.080736866,   0.11740022, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,  0.026294418,  0.064210536,   0.10455906,   0.14702974,   0.19133528,   0.23717815,   0.28425523,   0.33227678,   0.38098130,   0.43013845,   0.47954857,   0.52905289, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, 0.0022273311,  0.010687448,  0.019162814,  0.027935247,  0.037452057,  0.048456773,  0.061757081,  0.078206456,  0.098537138,   0.12317005,   0.15219131,   0.18536805,   0.22265749,   0.26385838,   0.30848667,   0.35614442,   0.40662318,   0.45974897,   0.51528284,   0.57289093,   0.63216919,   0.69269544,   0.75408003,   0.81599428,   0.87817617,   0.94044367, ;
 0.046321635,  0.050048651,  0.058714606,  0.072847802,  0.083973348,  0.094569850,   0.10990454,   0.12853566,   0.14836571,   0.16827483,   0.18824120,   0.20896733,   0.23146833,   0.25669551,   0.28538008,   0.31796339,   0.35456339,   0.39494151,   0.43875052,   0.48579042,   0.53601814,   0.58954588,   0.64650406,   0.70693249,   0.77073916,   0.83767455,   0.90732603,   0.97914184,    1.0524955,    1.1267723,    1.2014749,    1.2762879,    1.3510873, ;
  0.14875736,   0.16165561,   0.17256938,   0.18065040,   0.18767250,   0.19916431,   0.22161316,   0.24991379,   0.28068327,   0.31203767,   0.34311161,   0.37487526,   0.40890947,   0.44622576,   0.48750988,   0.53296916,   0.58232659,   0.63484189,   0.68958877,   0.74616514,   0.80527040,   0.86780267,   0.93430452,    1.0049411,    1.0796360,    1.1581398,    1.2400322,    1.3246730,    1.4112098,    1.4986535,    1.5861260,    1.6732774,    1.7602548, ;
  0.22627043,   0.24799720,   0.26125670,   0.26720233,   0.27737377,   0.29463805,   0.32417759,   0.36102199,   0.40226325,   0.44522384,   0.48765887,   0.53075563,   0.57653364,   0.62608921,   0.68035248,   0.73926287,   0.80194941,   0.86743441,   0.93396912,    1.0002558,    1.0690466,    1.1417908,    1.2189362,    1.3005516,    1.3865395,    1.4767043,    1.5707708,    1.6682293,    1.7680365,    1.8688004,    1.9689483,    2.0681465,    2.1672557, ;
  0.25053325,   0.28092069,   0.29574900,   0.30934224,   0.32915856,   0.36012127,   0.40465559,   0.45529467,   0.50920584,   0.56406674,   0.61854175,   0.67385697,   0.73194751,   0.79430991,   0.86170977,   0.93387211,    1.0094513,    1.0867683,    1.1648413,    1.2439703,    1.3256726,    1.4110142,    1.5004772,    1.5941597,    1.6920367,    1.7940194,    1.8999079,    2.0096665,    2.1218585,    2.2347849,    2.3475280,    2.4598202,    2.5718953, ;
  0.25053325,   0.28469858,   0.30531927,   0.33182202,   0.36850531,   0.41773493,   0.47673709,   0.53956147,   0.60567998,   0.67227839,   0.73869587,   0.80625600,   0.87683520,   0.95187929,    1.0319628,    1.1165702,    1.2043696,    1.2943559,    1.3861270,    1.4799081,    1.5763260,    1.6760566,    1.7794790,    1.8864404,    1.9969409,    2.1114040,    2.2293297,    2.3505023,    2.4740080,    2.5988401,    2.7242174,    2.8494204,    2.9742324, ;
  0.25053325,   0.28559453,   0.32151274,   0.36405141,   0.41935599,   0.48464247,   0.55419421,   0.62571573,   0.70123340,   0.77770183,   0.85445177,   0.93288084,    1.0152295,    1.1027759,    1.1950477,    1.2917633,    1.3924128,    1.4963470,    1.6030294,    1.7121789,    1.8238483,    1.9385939,    2.0568448,    2.1782486,    2.3024375,    2.4296747,    2.5597737,    2.6924328,    2.8272453,    2.9636370,    3.1009380,    3.2381173,    3.3749438, ;
  0.25053325,   0.29360294,   0.35056960,   0.41299606,   0.48297462,   0.55882961,   0.63711383,   0.71702212,   0.80077867,   0.88577826,   0.97153445,    1.0600772,    1.1533906,    1.2517300,    1.3552331,    1.4640755,    1.5782497,    1.6971050,    1.8196070,    1.9447542,    2.0719248,    2.2018000,    2.3344402,    2.4698278,    2.6079776,    2.7487682,    2.8918355,    3.0368186,    3.1836898,    3.3316796,    3.4800759,    3.6281881,    3.7758426, ;
  0.25053325,   0.31144778,   0.38780358,   0.46717029,   0.54942652,   0.63381695,   0.72027441,   0.80896179,   0.90225149,   0.99694202,    1.0924224,    1.1905295,    1.2933426,    1.4020261,    1.5171953,    1.6384985,    1.7662588,    1.9002777,    2.0389681,    2.1801418,    2.3224584,    2.4661097,    2.6120299,    2.7610771,    2.9135207,    3.0689476,    3.2264050,    3.3851972,    3.5446719,    3.7043126,    3.8637950,    4.0223992,    4.1797588, ;
  0.25053325,   0.33961286,   0.43135315,   0.52376718,   0.61683411,   0.71105753,   0.80711747,   0.90496900,    1.0076300,    1.1123215,    1.2174223,    1.3250459,    1.4380702,    1.5581914,    1.6861107,    1.8210343,    1.9619938,    2.1095015,    2.2625559,    2.4180306,    2.5738557,    2.7302324,    2.8890706,    3.0522825,    3.2197821,    3.3906467,    3.5634744,    3.7370831,    3.9102613,    4.0822017,    4.2528517,    4.4222556,    4.5908367, ;
  0.27303951,   0.37578779,   0.47856013,   0.58124473,   0.68425563,   0.78839814,   0.89416389,    1.0019184,    1.1160904,    1.2316641,    1.3467505,    1.4640860,    1.5872023,    1.7186169,    1.8589941,    2.0068877,    2.1609700,    2.3211776,    2.4860157,    2.6536817,    2.8228019,    2.9930949,    3.1667150,    3.3453185,    3.5285021,    3.7147980,    3.9026920,    4.0915798,    4.2799924,    4.4670295,    4.6520751,    4.8350975,    5.0168379, ;
  0.30732600,   0.41856420,   0.52961802,   0.64051922,   0.75273239,   0.86724239,   0.98421897,    1.1038312,    1.2292171,    1.3556304,    1.4817254,    1.6098385,    1.7432541,    1.8846598,    2.0352555,    2.1940658,    2.3606712,    2.5338613,    2.7117370,    2.8923095,    3.0744831,    3.2599190,    3.4494042,    3.6431499,    3.8411341,    4.0416255,    4.2438885,    4.4486172,    4.6551673,    4.8616851,    5.0656135,    5.2673888,    5.4678666, ;
  0.34827485,   0.46662404,   0.58475067,   0.70298987,   0.82415615,   0.94922256,    1.0779619,    1.2098706,    1.3456592,    1.4828875,    1.6211681,    1.7611440,    1.9050980,    2.0558687,    2.2157629,    2.3851062,    2.5634547,    2.7495954,    2.9414911,    3.1363310,    3.3333039,    3.5343061,    3.7397107,    3.9481988,    4.1583514,    4.3710911,    4.5877215,    4.8093293,    5.0365638,    5.2674355,    5.4986418,    5.7287899,    5.9577028, ;
  0.39332184,   0.51811234,   0.64269362,   0.76831856,   0.89852105,    1.0347716,    1.1746070,    1.3176731,    1.4642688,    1.6131152,    1.7636904,    1.9161331,    2.0719406,    2.2329064,    2.4023881,    2.5828869,    2.7728279,    2.9699509,    3.1730573,    3.3823953,    3.5956490,    3.8117560,    4.0306901,    4.2523980,    4.4772520,    4.7055872,    4.9378306,    5.1780314,    5.4301956,    5.6928934,    5.9614740,    6.2319536,    6.5038334, ;
  0.44053656,   0.57210464,   0.70373420,   0.83713920,   0.97682490,    1.1233545,    1.2748474,    1.4298305,    1.5878075,    1.7477746,    1.9096202,    2.0744581,    2.2440989,    2.4187493,    2.5997563,    2.7893073,    2.9886945,    3.1961385,    3.4112657,    3.6334295,    3.8602713,    4.0887410,    4.3198033,    4.5565137,    4.7992143,    5.0452892,    5.2957865,    5.5601353,    5.8449117,    6.1470947,    6.4624494,    6.7909840,    7.1273478, ;
  0.48858441,   0.62757403,   0.76684905,   0.90859106,    1.0578540,    1.2138626,    1.3757979,    1.5424209,    1.7124132,    1.8842778,    2.0575521,    2.2345872,    2.4174383,    2.6068524,    2.8026858,    3.0034657,    3.2092217,    3.4253457,    3.6522747,    3.8860268,    4.1212902,    4.3602563,    4.6075149,    4.8625987,    5.1223893,    5.3887865,    5.6694771,    5.9703520,    6.2946677,    6.6487501,    7.0261946,    7.4285121,    7.8454126, ;
  0.53595573,   0.68383465,   0.83210482,   0.98271308,    1.1403855,    1.3049176,    1.4760253,    1.6531831,    1.8353456,    2.0190587,    2.2035197,    2.3917625,    2.5873274,    2.7911360,    3.0018591,    3.2163105,    3.4349055,    3.6596810,    3.8925164,    4.1320307,    4.3775879,    4.6321035,    4.8971448,    5.1724694,    5.4575067,    5.7562027,    6.0759119,    6.4280058,    6.8146113,    7.2433063,    7.6951487,    8.1691760,    8.6528900, ;
  0.58032810,   0.73942162,   0.89882771,    1.0590735,    1.2242769,    1.3967054,    1.5770597,    1.7658829,    1.9603680,    2.1553687,    2.3514068,    2.5504240,    2.7554343,    2.9701201,    3.1949973,    3.4263165,    3.6610207,    3.8970754,    4.1336301,    4.3764874,    4.6328507,    4.9046255,    5.1907059,    5.4927190,    5.8128934,    6.1526953,    6.5251819,    6.9485719,    7.4220403,    7.9400506,    8.4667188,    8.9886340,    9.5030698, ;
  0.61826497,   0.79062054,   0.96241154,    1.1326010,    1.3077444,    1.4904623,    1.6816640,    1.8819035,    2.0865064,    2.2920875,    2.4997577,    2.7113226,    2.9285805,    3.1526744,    3.3879799,    3.6339752,    3.8832231,    4.1294590,    4.3753118,    4.6282862,    4.8948925,    5.1813587,    5.4927039,    5.8288082,    6.1893048,    6.5847034,    7.0268358,    7.5319326,    8.0854724,    8.6669985,    9.2415813,    9.7920708,    10.321608, ;
  0.64543970,   0.83223427,    1.0173997,    1.2004375,    1.3908988,    1.5880653,    1.7918057,    2.0021059,    2.2154181,    2.4316194,    2.6515254,    2.8760432,    3.1075959,    3.3452228,    3.5889334,    3.8418018,    4.0994042,    4.3577714,    4.6195642,    4.8886339,    5.1697175,    5.4734182,    5.8120978,    6.1850603,    6.6017982,    7.0729878,    7.5971485,    8.1704706,    8.7671111,    9.3659479,    9.9501040,    10.509218,    11.056194, ;
  0.65913338,   0.86333882,    1.0657275,    1.2680349,    1.4778332,    1.6922603,    1.9096744,    2.1301678,    2.3537862,    2.5820194,    2.8151275,    3.0530468,    3.2987157,    3.5492450,    3.8026018,    4.0576383,    4.3195884,    4.5922874,    4.8717866,    5.1591040,    5.4616656,    5.7916538,    6.1639277,    6.5860602,    7.0739369,    7.6304263,    8.2337483,    8.8497125,    9.4527504,    10.036032,    10.601569,    11.158022,    11.715915, ;
  0.66009949,   0.88620292,    1.1105559,    1.3370903,    1.5703177,    1.8054838,    2.0390597,    2.2725386,    2.5105537,    2.7532741,    2.9998689,    3.2504863,    3.5075822,    3.7688414,    4.0304211,    4.2910317,    4.5604615,    4.8442375,    5.1378098,    5.4464110,    5.7803369,    6.1512989,    6.5776358,    7.0689631,    7.6386930,    8.2674151,    8.9176816,    9.5474697,    10.139712,    10.699715,    11.244771,    11.791846,    12.344322, ;
  0.66009949,   0.90645899,    1.1552840,    1.4084489,    1.6666472,    1.9253370,    2.1788386,    2.4309533,    2.6854782,    2.9426312,    3.1999604,    3.4621978,    3.7312286,    4.0042725,    4.2764385,    4.5489332,    4.8274352,    5.1151372,    5.4195181,    5.7534164,    6.1298379,    6.5642947,    7.0691810,    7.6470651,    8.2872978,    8.9611015,    9.6275127,    10.253519,    10.824561,    11.366480,    11.898388,    12.435865,    12.980423, ;
  0.66088787,   0.93176550,    1.2042328,    1.4809996,    1.7615344,    2.0417104,    2.3178853,    2.5929293,    2.8673561,    3.1392965,    3.4103329,    3.6861824,    3.9698664,    4.2578560,    4.5441571,    4.8263211,    5.1069075,    5.3968801,    5.7143546,    6.0792872,    6.5113515,    7.0274220,    7.6196211,    8.2737934,    8.9663910,    9.6553156,    10.309554,    10.923269,    11.491030,    12.036169,    12.571600,    13.107540,    13.647640, ;
  0.67218967,   0.96504060,    1.2588830,    1.5553850,    1.8541087,    2.1522233,    2.4490466,    2.7450224,    3.0398110,    3.3331902,    3.6263821,    3.9215926,    4.2212495,    4.5219024,    4.8178865,    5.1056299,    5.3898091,    5.6871731,    6.0197974,    6.4135240,    6.9078833,    7.5006960,    8.1773299,    8.8893378,    9.6035400,    10.295118,    10.948218,    11.565547,    12.150604,    12.713326,    13.261844,    13.805161,    14.349039, ;
  0.69336881,    1.0060125,    1.3189285,    1.6325500,    1.9464862,    2.2600927,    2.5740988,    2.8890679,    3.2057557,    3.5237550,    3.8413904,    4.1570235,    4.4714665,    4.7818817,    5.0843023,    5.3785937,    5.6729701,    5.9834499,    6.3343904,    6.7491788,    7.2903261,    7.9288568,    8.6506441,    9.4100767,    10.169122,    10.898324,    11.581165,    12.219957,    12.824041,    13.402733,    13.965797,    14.521232,    15.075537, ;
  0.72213274,    1.0524821,    1.3827536,    1.7126255,    2.0411887,    2.3683057,    2.6970830,    3.0300917,    3.3694412,    3.7111689,    4.0513769,    4.3864051,    4.7150631,    5.0347476,    5.3441496,    5.6482754,    5.9543033,    6.2783143,    6.6506885,    7.1037675,    7.6688414,    8.3492768,    9.1141067,    9.9197927,    10.721498,    11.492959,    12.211708,    12.877620,    13.501128,    14.096885,    14.676279,    15.247175,    15.816255, ;
  0.75541342,    1.1017924,    1.4477584,    1.7925177,    2.1350363,    2.4769547,    2.8215937,    3.1733341,    3.5334231,    3.8956998,    4.2554385,    4.6085864,    4.9512335,    5.2806902,    5.6005571,    5.9153376,    6.2311917,    6.5751178,    6.9790028,    7.4740441,    8.0754525,    8.7877627,    9.5898789,    10.436646,    11.279668,    12.086831,    12.833020,    13.526209,    14.174779,    14.792161,    15.388855,    15.976024,    16.563397, ;
  0.79036444,    1.1519809,    1.5130108,    1.8725591,    2.2296439,    2.5873304,    2.9498995,    3.3210255,    3.6994987,    4.0802862,    4.4578929,    4.8269463,    5.1824764,    5.5226495,    5.8509579,    6.1722883,    6.5037741,    6.8748250,    7.3163697,    7.8531673,    8.4970875,    9.2472394,    10.083343,    10.961689,    11.834646,    12.668540,    13.448115,    14.173302,    14.849092,    15.487682,    16.103058,    16.709304,    17.314240, ]; 
engine.fast_torque_fuel_adjust_norm =  0; 
engine.refuel_profile_mult = [     1.0000000,	   1.0000000,	   1.0000000,	 ]; 
engine.refuel_profile_time_secs = [    0.00000000,	  0.10000000,	   8.0000000,	 ]; 
engine.refuel_limit_gps =    0.00000000; 
engine.refuel_min_defuel_duration_secs =     1.0000000; 
engine.acceleration_penalty_gpradps2 =    0.00000000; 
engine.acceleration_penalty_squelch_gps =    0.10000000; 
engine.decel_fuel_shutoff_disabled =  0; 
engine.decel_fuel_shutoff_condition =  '1'; 

